<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateShipmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('shipments', function (Blueprint $table) {
            $table->id();
            $table->string('form_status')->default('draft'); //created partially or fully
            $table->string('awb_no');
            $table->string('bardcode');
            $table->string('shipment_type');
            $table->string('service_provider');
            $table->string('shipment_purpose')->nullable();
            $table->string('shipment_reference')->nullable();
            $table->string('from_name');
            $table->string('from_country');
            $table->string('from_state')->nullable();
            $table->string('from_city');
            $table->string('from_street')->nullable();
            $table->string('to_name');
            $table->string('to_country');
            $table->string('to_state')->nullable();
            $table->string('to_city');
            $table->string('to_street')->nullable();
            $table->string('status')->default('pending');  //pending will be replaced later
            $table->double('gross_total');
            $table->double('discount');
            $table->double('tax');
            $table->double('service_charge');
            $table->double('net_total');
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->string('created_by_name')->nullable();
            $table->string('updated_by_name')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('shipments');
    }
}
